/************************************************************************
	hardware.h

    LED Light String Display
    Copyright (C) 2009 Simon Inns

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

	Email: simon.inns@gmail.com

************************************************************************/

#ifndef _HARDWARE_H_
#define _HARDWARE_H_

// Fosc frequency (48 Mhz)
#define _XTAL_FREQ 48000000

// Common useful definitions
#define ON 	1
#define OFF	0
#define	WRITE	0
#define READ	1
#define FALSE	0
#define TRUE	1

// LED outputs (left to right)
#define LED0	RB5
#define LED1	RB4
#define LED2	RB3
#define LED3	RB2
#define LED4	RB1
#define LED5	RB0
#define LED6	RC7

// Define a structure to represent the lights
struct ledState {
	// Variables for foreground control
	int brightness;	// Target brightness
	int fadeOnSpeed;	// Fade ON speed (in PWM steps 1-31)
	int fadeOffSpeed;	// Fade OFF speed (in PWM steps 1-31)

	// Variables for interrupt control
	int currentBrightness;
	int fadeCounter;
} led[8];

#endif